/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.entity;

import com.starfish_studios.naturalist.entity.ai.goal.AttackPlayerNearBabiesGoal;
import com.starfish_studios.naturalist.entity.ai.goal.BabyHurtByTargetGoal;
import com.starfish_studios.naturalist.entity.ai.goal.BabyPanicGoal;
import com.starfish_studios.naturalist.entity.ai.goal.DistancedFollowParentGoal;
import com.starfish_studios.naturalist.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.registry.NaturalistSoundEvents;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1322;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1367;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3730;
import net.minecraft.class_4466;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class Elephant
extends class_1429
implements IAnimatable {
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private static final class_2940<Integer> DIRTY_TICKS = class_2945.method_12791(Elephant.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> DRINKING = class_2945.method_12791(Elephant.class, (class_2941)class_2943.field_13323);
    @Nullable
    protected class_2338 waterPos;

    public Elephant(class_1299<? extends class_1429> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6013 = 1.0f;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 50.0).method_26868(class_5134.field_23719, 0.2).method_26868(class_5134.field_23721, 6.0).method_26868(class_5134.field_23718, 0.75).method_26868(class_5134.field_23717, 20.0);
    }

    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        class_1296.class_4697 ageableMobGroupData;
        if (spawnData == null) {
            spawnData = new class_1296.class_4697(true);
        }
        if ((ageableMobGroupData = (class_1296.class_4697)spawnData).method_22432() > 1) {
            this.method_5614(-24000);
        }
        ageableMobGroupData.method_22435();
        class_5819 random = level.method_8409();
        this.method_5996(class_5134.field_23717).method_26837(new class_1322("Random spawn bonus", random.method_43385(0.0, 0.11485000000000001), class_1322.class_1323.field_6330));
        return spawnData;
    }

    @Nullable
    public class_1296 method_5613(class_3218 serverLevel, class_1296 ageableMob) {
        return (class_1296)NaturalistEntityTypes.ELEPHANT.get().method_5883((class_1937)serverLevel);
    }

    protected class_1408 method_5965(class_1937 level) {
        return new class_1409((class_1308)this, level);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1338((class_1314)this, class_4466.class, 8.0f, 1.5, 1.5));
        this.field_6201.method_6277(2, (class_1352)new ElephantMeleeAttackGoal((class_1314)this, 1.2, false));
        this.field_6201.method_6277(3, (class_1352)new BabyPanicGoal((class_1314)this, 2.0));
        this.field_6201.method_6277(4, (class_1352)new DistancedFollowParentGoal(this, 1.25, 24.0, 6.0, 12.0));
        this.field_6201.method_6277(5, (class_1352)new ElephantDrinkWaterGoal(this));
        this.field_6201.method_6277(6, (class_1352)new ElephantMoveToWaterGoal(this, 1.0, 8, 4));
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(9, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new BabyHurtByTargetGoal((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new AttackPlayerNearBabiesGoal((class_1308)this, 0.5f));
    }

    public int method_5986() {
        return 35;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return NaturalistSoundEvents.ELEPHANT_HURT.get();
    }

    @Nullable
    protected class_3414 method_5994() {
        return NaturalistSoundEvents.ELEPHANT_AMBIENT.get();
    }

    public boolean method_6121(class_1297 target) {
        boolean shouldHurt = target.method_5643(class_1282.method_5511((class_1309)this), (float)this.method_26825(class_5134.field_23721));
        if (shouldHurt && target instanceof class_1309) {
            class_1309 livingEntity = (class_1309)target;
            class_243 knockbackDirection = new class_243((double)this.method_24515().method_10263() - target.method_23317(), 0.0, (double)this.method_24515().method_10260() - target.method_23321()).method_1029();
            float shieldBlockModifier = livingEntity.method_6061(class_1282.method_5511((class_1309)this)) ? 0.5f : 1.0f;
            livingEntity.method_6005((double)shieldBlockModifier * 3.0, knockbackDirection.method_10216(), knockbackDirection.method_10215());
            double knockbackResistance = Math.max(0.0, 1.0 - livingEntity.method_26825(class_5134.field_23718));
            livingEntity.method_18799(livingEntity.method_18798().method_1031(0.0, 0.5 * knockbackResistance, 0.0));
        }
        this.method_5783(class_3417.field_15240, 1.0f, 1.0f);
        return shouldHurt;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DIRTY_TICKS, (Object)0);
        this.field_6011.method_12784(DRINKING, (Object)false);
    }

    public void method_5652(class_2487 pCompound) {
        super.method_5652(pCompound);
        pCompound.method_10569("DirtyTicks", this.getDirtyTicks());
    }

    public void method_5749(class_2487 pCompound) {
        super.method_5749(pCompound);
        this.setDirtyTicks(pCompound.method_10550("DirtyTicks"));
    }

    public void setDirtyTicks(int ticks) {
        this.field_6011.method_12778(DIRTY_TICKS, (Object)ticks);
    }

    public int getDirtyTicks() {
        return (Integer)this.field_6011.method_12789(DIRTY_TICKS);
    }

    public boolean isDirty() {
        return this.getDirtyTicks() > 0;
    }

    public void setDrinking(boolean drinking) {
        this.field_6011.method_12778(DRINKING, (Object)drinking);
    }

    public boolean isDrinking() {
        return (Boolean)this.field_6011.method_12789(DRINKING);
    }

    public void method_6007() {
        super.method_6007();
        class_1937 class_19372 = this.field_6002;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.isDirty()) {
                this.setDirtyTicks(this.method_5799() ? 0 : Math.max(0, this.getDirtyTicks() - 1));
            } else {
                long dayTime = serverLevel.method_8532();
                if (dayTime > 4300L && dayTime < 11000L && this.method_24828() && this.method_6051().method_43057() < 0.001f && !this.isDrinking()) {
                    this.method_6104(class_1268.field_5808);
                    this.setDirtyTicks(1000);
                    serverLevel.method_14199((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10566.method_9564()), this.method_23317(), this.method_23318(), this.method_23321(), 200, 0.5, 3.0, 0.5, 10.0);
                }
            }
        }
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.method_18798().method_37268() > 1.0E-6) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("elephant.walk", Boolean.valueOf(true)));
        } else if (this.isDrinking()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("elephant.water", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("elephant.idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState swingPredicate(AnimationEvent<E> event) {
        if (this.field_6252 && event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            event.getController().setAnimation(new AnimationBuilder().addAnimation("elephant.swing", Boolean.valueOf(false)));
            this.field_6252 = false;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.setResetSpeedInTicks(10.0);
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 10.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "swingController", 0.0f, this::swingPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class ElephantMeleeAttackGoal
    extends class_1366 {
        public ElephantMeleeAttackGoal(class_1314 pathfinderMob, double speedMultiplier, boolean followingTargetEvenIfNotSeen) {
            super(pathfinderMob, speedMultiplier, followingTargetEvenIfNotSeen);
        }

        protected double method_6289(class_1309 attackTarget) {
            return class_3532.method_27285((float)this.field_6503.method_17681());
        }
    }

    static class ElephantDrinkWaterGoal
    extends class_1352 {
        private final Elephant elephant;
        private int drinkTicks;

        public ElephantDrinkWaterGoal(Elephant elephant) {
            this.elephant = elephant;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18407, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            if (this.elephant.waterPos == null || this.elephant.method_5707(class_243.method_24953((class_2382)this.elephant.waterPos)) > 15.0) {
                this.elephant.setDrinking(false);
                return false;
            }
            return this.elephant.isDrinking();
        }

        public boolean method_6266() {
            return this.drinkTicks > 0 && super.method_6266();
        }

        public void method_6269() {
            this.drinkTicks = 150;
            if (this.elephant.waterPos != null) {
                this.elephant.method_5988().method_19615(class_243.method_24953((class_2382)this.elephant.waterPos));
            }
        }

        public void method_6268() {
            --this.drinkTicks;
            if (this.elephant.waterPos != null) {
                this.elephant.method_5988().method_19615(class_243.method_24953((class_2382)this.elephant.waterPos));
            }
        }

        public void method_6270() {
            this.elephant.waterPos = null;
            this.elephant.setDrinking(false);
        }
    }

    static class ElephantMoveToWaterGoal
    extends class_1367 {
        private final Elephant elephant;

        public ElephantMoveToWaterGoal(Elephant pathfinderMob, double speedModifier, int searchRange, int verticalSearchRange) {
            super((class_1314)pathfinderMob, speedModifier, searchRange, verticalSearchRange);
            this.elephant = pathfinderMob;
        }

        public boolean method_6264() {
            return !this.elephant.method_6109() && !this.elephant.isDrinking() && this.elephant.waterPos == null && super.method_6264();
        }

        public boolean method_6266() {
            return !this.method_6295() && super.method_6266();
        }

        protected boolean method_6296(class_4538 level, class_2338 pos) {
            if (level.method_8320(pos).method_27852(class_2246.field_10219)) {
                for (class_2350 direction : class_2350.class_2353.field_11062) {
                    if (!level.method_8316(pos.method_10093(direction)).method_39360((class_3611)class_3612.field_15910)) continue;
                    this.elephant.waterPos = pos.method_10093(direction);
                    return true;
                }
            }
            return false;
        }

        public double method_6291() {
            return 2.5;
        }

        public void method_6270() {
            this.elephant.setDrinking(true);
            super.method_6270();
        }
    }
}

